/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.cdi.Services;
import com.equestricraft.mod.packet.PacketUtil;
import com.equestricraft.mod.player.OnlinePlayer;
import com.equestricraft.mod.plot.PlotService;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ServerBoundPlotAccessListMenuOpenPacket {
    private final int plotId;
    private final int pageNumber;

    public ServerBoundPlotAccessListMenuOpenPacket(int plotId, int pageNumber) {
        this.plotId = plotId;
        this.pageNumber = pageNumber;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.plotId);
        buffer.writeInt(this.pageNumber);
    }

    public static ServerBoundPlotAccessListMenuOpenPacket decode(FriendlyByteBuf buffer) {
        int plotId = buffer.readInt();
        int pageNumber = buffer.readInt();
        return new ServerBoundPlotAccessListMenuOpenPacket(plotId, pageNumber);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleServerPacketAsync(context, p -> {
            PlotService service = Services.getService(PlotService.class);
            service.showPlotAccessMenu((OnlinePlayer)p, this.plotId, this.pageNumber);
        });
    }
}

