/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.base.response.Response;
import com.equestricraft.cdi.Services;
import com.equestricraft.core.plot.approval.PlotActionType;
import com.equestricraft.mod.packet.PacketUtil;
import com.equestricraft.mod.player.OnlinePlayer;
import com.equestricraft.mod.plot.PlotService;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ServerBoundPlotApprovalAcceptPacket {
    private final int plotId;
    private final PlotActionType actionType;

    public ServerBoundPlotApprovalAcceptPacket(int plotId, PlotActionType actionType) {
        this.plotId = plotId;
        this.actionType = actionType;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.plotId);
        buffer.m_130068_((Enum)this.actionType);
    }

    public static ServerBoundPlotApprovalAcceptPacket decode(FriendlyByteBuf buffer) {
        int plotId = buffer.readInt();
        PlotActionType actionType = (PlotActionType)buffer.m_130066_(PlotActionType.class);
        return new ServerBoundPlotApprovalAcceptPacket(plotId, actionType);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleServerPacketAsync(context, p -> {
            PlotService service = Services.getService(PlotService.class);
            Response r = service.acceptApproval((OnlinePlayer)p, this.plotId, this.actionType);
            p.showResponse(r);
        });
    }
}

