/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.base.response.Response;
import com.equestricraft.cdi.Services;
import com.equestricraft.mod.packet.PacketUtil;
import com.equestricraft.mod.player.OnlinePlayer;
import com.equestricraft.mod.plot.PlotService;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ServerBoundPlotGrantAccessPacket {
    private final int plotId;

    public ServerBoundPlotGrantAccessPacket(int plotId) {
        this.plotId = plotId;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.plotId);
    }

    public static ServerBoundPlotGrantAccessPacket decode(FriendlyByteBuf buffer) {
        int plotId = buffer.readInt();
        return new ServerBoundPlotGrantAccessPacket(plotId);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleServerPacketAsync(context, p -> {
            PlotService service = Services.getService(PlotService.class);
            Response r = service.grantAccessToPlot((OnlinePlayer)p, this.plotId);
            p.showResponse(r);
        });
    }
}

