/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.base.response.Response;
import com.equestricraft.cdi.Services;
import com.equestricraft.common.coordinate.DirectionalCoordinate;
import com.equestricraft.mod.packet.PacketUtil;
import com.equestricraft.mod.player.OnlinePlayer;
import com.equestricraft.mod.plot.PlotService;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ServerBoundPlotGridPurchasePacket {
    private final DirectionalCoordinate coordinate;
    private final String name;

    public ServerBoundPlotGridPurchasePacket(DirectionalCoordinate coordinate, String name) {
        this.coordinate = coordinate;
        this.name = name;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeDouble(this.coordinate.x());
        buffer.writeDouble(this.coordinate.y());
        buffer.writeDouble(this.coordinate.z());
        buffer.m_130070_(this.coordinate.world());
        buffer.writeFloat(this.coordinate.rotationY());
        buffer.writeFloat(this.coordinate.rotationX());
        buffer.m_130070_(this.name);
    }

    public static ServerBoundPlotGridPurchasePacket decode(FriendlyByteBuf buffer) {
        double x = buffer.readDouble();
        double y = buffer.readDouble();
        double z = buffer.readDouble();
        String world = buffer.m_130277_();
        float rotationY = buffer.readFloat();
        float rotationX = buffer.readFloat();
        DirectionalCoordinate coordinate = new DirectionalCoordinate(x, y, z, world, rotationY, rotationX);
        String name = buffer.m_130277_();
        return new ServerBoundPlotGridPurchasePacket(coordinate, name);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleServerPacketAsync(context, p -> {
            PlotService service = Services.getService(PlotService.class);
            Response r = service.purchaseGrid((OnlinePlayer)p, this.coordinate, this.name);
            p.showResponse(r);
        });
    }
}

