/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.cdi.Services;
import com.equestricraft.mod.packet.PacketUtil;
import com.equestricraft.mod.player.OnlinePlayer;
import com.equestricraft.mod.plot.PlotService;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ServerBoundPlotListMenuOpenPacket {
    private final int pageNumber;

    public ServerBoundPlotListMenuOpenPacket(int pageNumber) {
        this.pageNumber = pageNumber;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.pageNumber);
    }

    public static ServerBoundPlotListMenuOpenPacket decode(FriendlyByteBuf buffer) {
        int pageNumber = buffer.readInt();
        return new ServerBoundPlotListMenuOpenPacket(pageNumber);
    }

    public boolean handle(Supplier<NetworkEvent.Context> contextSupplier) {
        return PacketUtil.handleServerPacketAsync(contextSupplier, p -> {
            PlotService service = Services.getService(PlotService.class);
            service.showPlayersPlotMenu((OnlinePlayer)p, this.pageNumber);
        });
    }
}

