/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.base.response.Response;
import com.equestricraft.cdi.Services;
import com.equestricraft.mod.packet.PacketUtil;
import com.equestricraft.mod.player.OnlinePlayer;
import com.equestricraft.mod.plot.PlotService;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ServerBoundPlotMergeSelectPacket {
    private final int targetPlotId;
    private final int sourcePlotId;

    public ServerBoundPlotMergeSelectPacket(int targetPlotId, int sourcePlotId) {
        this.targetPlotId = targetPlotId;
        this.sourcePlotId = sourcePlotId;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.targetPlotId);
        buffer.writeInt(this.sourcePlotId);
    }

    public static ServerBoundPlotMergeSelectPacket decode(FriendlyByteBuf buffer) {
        int targetPlotId = buffer.readInt();
        int sourcePlotId = buffer.readInt();
        return new ServerBoundPlotMergeSelectPacket(targetPlotId, sourcePlotId);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleServerPacketAsync(context, p -> {
            PlotService service = Services.getService(PlotService.class);
            Response r = service.mergePlots((OnlinePlayer)p, this.targetPlotId, this.sourcePlotId);
            p.showResponse(r);
        });
    }
}

