/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.cdi.Services;
import com.equestricraft.mod.packet.PacketUtil;
import com.equestricraft.mod.player.OnlinePlayer;
import com.equestricraft.mod.plot.PlotService;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ServerBoundPlotNearbyAreasUpdatePacket {
    private final int x;
    private final int z;
    private final int radius;

    public ServerBoundPlotNearbyAreasUpdatePacket(int x, int z, int radius) {
        this.x = x;
        this.z = z;
        this.radius = radius;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.x);
        buffer.writeInt(this.z);
        buffer.writeInt(this.radius);
    }

    public static ServerBoundPlotNearbyAreasUpdatePacket decode(FriendlyByteBuf buffer) {
        int x = buffer.readInt();
        int z = buffer.readInt();
        int radius = buffer.readInt();
        return new ServerBoundPlotNearbyAreasUpdatePacket(x, z, radius);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleServerPacketAsync(context, p -> {
            PlotService service = Services.getService(PlotService.class);
            service.sendNearbyAreasUpdate((OnlinePlayer)p, this.x, this.z, this.radius);
        });
    }
}

