/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.cdi.Services;
import com.equestricraft.mod.packet.PacketUtil;
import com.equestricraft.mod.player.OnlinePlayer;
import com.equestricraft.mod.plot.PlotService;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ServerBoundPlotPendingApprovalsRequestPacket {
    private final int pageNumber;

    public ServerBoundPlotPendingApprovalsRequestPacket(int pageNumber) {
        this.pageNumber = pageNumber;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.pageNumber);
    }

    public static ServerBoundPlotPendingApprovalsRequestPacket decode(FriendlyByteBuf buffer) {
        int pageNumber = buffer.readInt();
        return new ServerBoundPlotPendingApprovalsRequestPacket(pageNumber);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleServerPacketAsync(context, p -> {
            PlotService service = Services.getService(PlotService.class);
            service.showPendingApprovalsMenuToPlayer((OnlinePlayer)p, this.pageNumber);
        });
    }
}

