/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.cdi.Services;
import com.equestricraft.mod.packet.PacketUtil;
import com.equestricraft.mod.player.OnlinePlayer;
import com.equestricraft.mod.plot.PlotService;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ServerBoundPlotPriceCalculationPacket {
    private final int radius;

    public ServerBoundPlotPriceCalculationPacket(int radius) {
        this.radius = radius;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.radius);
    }

    public static ServerBoundPlotPriceCalculationPacket decode(FriendlyByteBuf buffer) {
        int radius = buffer.readInt();
        return new ServerBoundPlotPriceCalculationPacket(radius);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleServerPacketAsync(context, p -> {
            PlotService service = Services.getService(PlotService.class);
            service.sendPriceCalculationUpdate((OnlinePlayer)p, this.radius);
        });
    }
}

