/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.base.response.Response;
import com.equestricraft.cdi.Services;
import com.equestricraft.mod.packet.PacketUtil;
import com.equestricraft.mod.player.OnlinePlayer;
import com.equestricraft.mod.plot.PlotService;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ServerBoundPlotPromotePlayerOwnerPacket {
    private final int plotId;
    private final int playerId;

    public ServerBoundPlotPromotePlayerOwnerPacket(int plotId, int playerId) {
        this.plotId = plotId;
        this.playerId = playerId;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.plotId);
        buffer.writeInt(this.playerId);
    }

    public static ServerBoundPlotPromotePlayerOwnerPacket decode(FriendlyByteBuf buffer) {
        int plotId = buffer.readInt();
        int playerId = buffer.readInt();
        return new ServerBoundPlotPromotePlayerOwnerPacket(plotId, playerId);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleServerPacketAsync(context, p -> {
            PlotService service = Services.getService(PlotService.class);
            Response r = service.promoteToOwner((OnlinePlayer)p, this.plotId, this.playerId);
            p.showResponse(r);
        });
    }
}

