/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.base.response.Response;
import com.equestricraft.cdi.Services;
import com.equestricraft.mod.packet.PacketUtil;
import com.equestricraft.mod.player.OnlinePlayer;
import com.equestricraft.mod.plot.PlotService;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ServerBoundPlotSellPacket {
    private final int plotId;
    private final int toPlayerId;
    private final double price;

    public ServerBoundPlotSellPacket(int plotId, int toPlayerId, double price) {
        this.plotId = plotId;
        this.toPlayerId = toPlayerId;
        this.price = price;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.plotId);
        buffer.writeInt(this.toPlayerId);
        buffer.writeDouble(this.price);
    }

    public static ServerBoundPlotSellPacket decode(FriendlyByteBuf buffer) {
        int plotId = buffer.readInt();
        int toPlayerId = buffer.readInt();
        double price = buffer.readDouble();
        return new ServerBoundPlotSellPacket(plotId, toPlayerId, price);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleServerPacketAsync(context, p -> {
            PlotService service = Services.getService(PlotService.class);
            Response r = service.sellPlot((OnlinePlayer)p, this.plotId, this.toPlayerId, this.price);
            p.showResponse(r);
        });
    }
}

