/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.base.response.Response;
import com.equestricraft.cdi.Services;
import com.equestricraft.mod.horse.prescription.PrescriptionService;
import com.equestricraft.mod.packet.PacketUtil;
import com.equestricraft.mod.player.OnlinePlayer;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ServerBoundPrescribeMedicinePacket {
    private final int horseId;
    private final int illnessId;

    public ServerBoundPrescribeMedicinePacket(int horseId, int illnessId) {
        this.horseId = horseId;
        this.illnessId = illnessId;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.horseId);
        buffer.writeInt(this.illnessId);
    }

    public static ServerBoundPrescribeMedicinePacket decode(FriendlyByteBuf buffer) {
        int horseId = buffer.readInt();
        int illnessId = buffer.readInt();
        return new ServerBoundPrescribeMedicinePacket(horseId, illnessId);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleServerPacketAsync(context, p -> {
            PrescriptionService service = Services.getService(PrescriptionService.class);
            Response r = service.showPrescriptionGiveMenu((OnlinePlayer)p, this.horseId, this.illnessId);
            p.showResponse(r);
        });
    }
}

