/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.base.pagination.SortDirection;
import com.equestricraft.base.response.Response;
import com.equestricraft.cdi.Services;
import com.equestricraft.mod.horse.prescription.PrescriptionService;
import com.equestricraft.mod.packet.PacketUtil;
import com.equestricraft.mod.player.OnlinePlayer;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ServerBoundPrescriptionListPageRequestPacket {
    private final int horseId;
    private final int pageNumber;
    private final SortDirection sortDirection;

    public ServerBoundPrescriptionListPageRequestPacket(int horseId, int pageNumber, SortDirection sortDirection) {
        this.horseId = horseId;
        this.pageNumber = pageNumber;
        this.sortDirection = sortDirection;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.horseId);
        buffer.writeInt(this.pageNumber);
        buffer.m_130068_((Enum)this.sortDirection);
    }

    public static ServerBoundPrescriptionListPageRequestPacket decode(FriendlyByteBuf buffer) {
        int horseId = buffer.readInt();
        int pageNumber = buffer.readInt();
        SortDirection sortDirection = (SortDirection)buffer.m_130066_(SortDirection.class);
        return new ServerBoundPrescriptionListPageRequestPacket(horseId, pageNumber, sortDirection);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleServerPacketAsync(context, p -> {
            PrescriptionService service = Services.getService(PrescriptionService.class);
            Response r = service.showPrescriptionsForHorse((OnlinePlayer)p, this.horseId, this.pageNumber, this.sortDirection);
            p.showResponse(r);
        });
    }
}

