/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.base.response.Response;
import com.equestricraft.cdi.Services;
import com.equestricraft.mod.horse.prescription.PrescriptionService;
import com.equestricraft.mod.packet.PacketUtil;
import com.equestricraft.mod.player.OnlinePlayer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ServerBoundPrescriptionSendPacket {
    private final int horseId;
    private final int illnessId;
    private final String description;
    private final List<Integer> medicineIds;

    public ServerBoundPrescriptionSendPacket(int horseId, int illnessId, String description, List<Integer> medicineIds) {
        this.horseId = horseId;
        this.illnessId = illnessId;
        this.description = description;
        this.medicineIds = medicineIds;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.horseId);
        buffer.writeInt(this.illnessId);
        buffer.m_130070_(this.description);
        buffer.writeInt(this.medicineIds.size());
        for (int medicineId : this.medicineIds) {
            buffer.writeInt(medicineId);
        }
    }

    public static ServerBoundPrescriptionSendPacket decode(FriendlyByteBuf buffer) {
        int horseId = buffer.readInt();
        int illnessId = buffer.readInt();
        String description = buffer.m_130277_();
        int medicineCount = buffer.readInt();
        ArrayList<Integer> medicineIds = new ArrayList<Integer>(medicineCount);
        for (int i = 0; i < medicineCount; ++i) {
            int medicineId = buffer.readInt();
            medicineIds.add(medicineId);
        }
        return new ServerBoundPrescriptionSendPacket(horseId, illnessId, description, medicineIds);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleServerPacketAsync(context, p -> {
            PrescriptionService s = Services.getService(PrescriptionService.class);
            Response r = s.sendPrescription((OnlinePlayer)p, this.horseId, this.illnessId, this.description, this.medicineIds);
            p.showResponse(r);
        });
    }
}

