/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.cdi.Services;
import com.equestricraft.mod.horse.progression.HorseProgressionService;
import com.equestricraft.mod.packet.PacketUtil;
import com.equestricraft.mod.player.OnlinePlayer;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ServerBoundProgressionMenuOpenPacket {
    private final int horseId;

    public ServerBoundProgressionMenuOpenPacket(int horseId) {
        this.horseId = horseId;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.horseId);
    }

    public static ServerBoundProgressionMenuOpenPacket decode(FriendlyByteBuf buffer) {
        int horseId = buffer.readInt();
        return new ServerBoundProgressionMenuOpenPacket(horseId);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleServerPacketAsync(context, p -> {
            HorseProgressionService service = Services.getService(HorseProgressionService.class);
            service.showHorseProgressionMenu((OnlinePlayer)p, this.horseId);
        });
    }
}

