/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.cdi.Services;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.mod.packet.PacketUtil;
import com.equestricraft.mod.provision.ProvisionService;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ServerBoundProvisionInventoryMenuOpenPacket {
    private final Integer horseId;
    private final int provisionId;
    private final int pageNumber;
    private final Integer containerEntityId;

    public ServerBoundProvisionInventoryMenuOpenPacket(Integer horseId, int provisionId, int pageNumber, Integer containerEntityId) {
        this.horseId = horseId;
        this.provisionId = provisionId;
        this.pageNumber = pageNumber;
        this.containerEntityId = containerEntityId;
    }

    public void encode(FriendlyByteBuf buffer) {
        if (this.horseId != null) {
            buffer.writeBoolean(true);
            buffer.writeInt(this.horseId.intValue());
        } else {
            buffer.writeBoolean(false);
        }
        buffer.writeInt(this.provisionId);
        buffer.writeInt(this.pageNumber);
        if (this.containerEntityId != null) {
            buffer.writeBoolean(true);
            buffer.writeInt(this.containerEntityId.intValue());
        } else {
            buffer.writeBoolean(false);
        }
    }

    public static ServerBoundProvisionInventoryMenuOpenPacket decode(FriendlyByteBuf buffer) {
        Integer horseId = buffer.readBoolean() ? Integer.valueOf(buffer.readInt()) : null;
        int provisionId = buffer.readInt();
        int pageNumber = buffer.readInt();
        Integer containerEntityId = buffer.readBoolean() ? Integer.valueOf(buffer.readInt()) : null;
        return new ServerBoundProvisionInventoryMenuOpenPacket(horseId, provisionId, pageNumber, containerEntityId);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleServerPacketAsync(context, p -> {
            ProvisionService service = Services.getService(ProvisionService.class);
            service.showProvisionMenuToPlayer((ECPlayer)p, this.horseId, this.provisionId, this.pageNumber, this.containerEntityId);
        });
    }
}

