/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.cdi.Services;
import com.equestricraft.common.QuestType;
import com.equestricraft.mod.packet.PacketUtil;
import com.equestricraft.mod.player.OnlinePlayer;
import com.equestricraft.mod.quest.QuestService;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ServerBoundQuestGroupMenuRequestPacket {
    private final int groupId;
    private final QuestType questType;

    public ServerBoundQuestGroupMenuRequestPacket(int groupId, QuestType questType) {
        this.groupId = groupId;
        this.questType = questType;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.groupId);
        buffer.m_130068_((Enum)this.questType);
    }

    public static ServerBoundQuestGroupMenuRequestPacket decode(FriendlyByteBuf buffer) {
        int groupId = buffer.readInt();
        QuestType questType = (QuestType)buffer.m_130066_(QuestType.class);
        return new ServerBoundQuestGroupMenuRequestPacket(groupId, questType);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleServerPacketAsync(context, p -> {
            QuestService questCommandService = Services.getService(QuestService.class);
            questCommandService.showMenuForGroup((OnlinePlayer)p, this.groupId, this.questType);
        });
    }
}

