/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.cdi.Services;
import com.equestricraft.common.QuestType;
import com.equestricraft.mod.packet.PacketUtil;
import com.equestricraft.mod.player.OnlinePlayer;
import com.equestricraft.mod.quest.QuestService;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ServerBoundQuestMainMenuResponsePacket {
    public static final int QUEST_MENU_SELECTION_IN_PROGRESS = 1;
    public static final int QUEST_MENU_SELECTION_AVAILABLE = 2;
    private final int selection;

    public ServerBoundQuestMainMenuResponsePacket(int selection) {
        this.selection = selection;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.selection);
    }

    public static ServerBoundQuestMainMenuResponsePacket decode(FriendlyByteBuf buffer) {
        int selection = buffer.readInt();
        return new ServerBoundQuestMainMenuResponsePacket(selection);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleServerPacketAsync(context, p -> {
            QuestService service = Services.getService(QuestService.class);
            if (this.selection == 1) {
                service.showInProgressQuestsMenu((OnlinePlayer)p);
            } else if (this.selection == 2) {
                service.showAvailableQuestsMenu((OnlinePlayer)p, QuestType.STANDARD);
            }
        });
    }
}

