/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.base.response.Response;
import com.equestricraft.cdi.Services;
import com.equestricraft.mod.packet.PacketUtil;
import com.equestricraft.mod.player.OnlinePlayer;
import com.equestricraft.mod.quest.QuestService;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ServerBoundQuestSetTrackedPacket {
    private final int questId;

    public ServerBoundQuestSetTrackedPacket(int questId) {
        this.questId = questId;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.questId);
    }

    public static ServerBoundQuestSetTrackedPacket decode(FriendlyByteBuf buffer) {
        int questId = buffer.readInt();
        return new ServerBoundQuestSetTrackedPacket(questId);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleServerPacketAsync(context, p -> {
            QuestService service = Services.getService(QuestService.class);
            Response response = service.setTrackedQuest((OnlinePlayer)p, this.questId);
            p.showResponse(response);
        });
    }
}

