/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.cdi.Services;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.mod.packet.PacketUtil;
import com.equestricraft.mod.quest.QuestService;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ServerBoundQuestStartPacket {
    private final int questId;
    private final UUID startElementId;

    public ServerBoundQuestStartPacket(int questId, UUID startElementId) {
        this.questId = questId;
        this.startElementId = startElementId;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.questId);
        buffer.m_130077_(this.startElementId);
    }

    public static ServerBoundQuestStartPacket decode(FriendlyByteBuf buffer) {
        int questId = buffer.readInt();
        UUID startElementId = buffer.m_130259_();
        return new ServerBoundQuestStartPacket(questId, startElementId);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleServerPacketAsync(context, p -> {
            QuestService questService = Services.getService(QuestService.class);
            questService.startQuest((ECPlayer)p, this.questId, this.startElementId);
        });
    }
}

