/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.base.response.Response;
import com.equestricraft.cdi.Services;
import com.equestricraft.mod.packet.PacketUtil;
import com.equestricraft.mod.player.OnlinePlayer;
import com.equestricraft.mod.registration.HorseRegistrationService;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ServerBoundRegisterHorseWithOrganizationPacket {
    private final int horseId;
    private final int organizationId;

    public ServerBoundRegisterHorseWithOrganizationPacket(int horseId, int organizationId) {
        this.horseId = horseId;
        this.organizationId = organizationId;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.horseId);
        buffer.writeInt(this.organizationId);
    }

    public static ServerBoundRegisterHorseWithOrganizationPacket decode(FriendlyByteBuf buffer) {
        int horseId = buffer.readInt();
        int organizationId = buffer.readInt();
        return new ServerBoundRegisterHorseWithOrganizationPacket(horseId, organizationId);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleServerPacketAsync(context, p -> {
            HorseRegistrationService service = Services.getService(HorseRegistrationService.class);
            Response r = service.showRegisterPrompt((OnlinePlayer)p, this.horseId, this.organizationId);
            p.showResponse(r);
        });
    }
}

