/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.cdi.Services;
import com.equestricraft.common.ECLevel;
import com.equestricraft.mod.horse.feeding.HorseProvisionContainerService;
import com.equestricraft.mod.packet.PacketUtil;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ServerBoundSetBucketContentsPacket {
    private final Integer containerEntityId;
    private final ECLevel level;
    private final UUID provisionItemUuid;

    public ServerBoundSetBucketContentsPacket(Integer containerEntityId, ECLevel level, UUID provisionItemUuid) {
        this.containerEntityId = containerEntityId;
        this.level = level;
        this.provisionItemUuid = provisionItemUuid;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.containerEntityId.intValue());
        buffer.m_130068_((Enum)this.level);
        buffer.m_130077_(this.provisionItemUuid);
    }

    public static ServerBoundSetBucketContentsPacket decode(FriendlyByteBuf buffer) {
        int coordinate = buffer.readInt();
        ECLevel level = (ECLevel)buffer.m_130066_(ECLevel.class);
        UUID uuid = buffer.m_130259_();
        return new ServerBoundSetBucketContentsPacket(coordinate, level, uuid);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleServerPacket(context, p -> {
            HorseProvisionContainerService service = Services.getService(HorseProvisionContainerService.class);
            service.setContainersContents(this.containerEntityId, this.level, this.provisionItemUuid);
        });
    }
}

