/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.base.response.Response;
import com.equestricraft.cdi.Services;
import com.equestricraft.mod.packet.PacketUtil;
import com.equestricraft.mod.player.OnlinePlayer;
import com.equestricraft.mod.shop.ShopService;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ServerBoundShopItemBuyPacket {
    private final int shopItemId;

    public ServerBoundShopItemBuyPacket(int shopItemId) {
        this.shopItemId = shopItemId;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.shopItemId);
    }

    public static ServerBoundShopItemBuyPacket decode(FriendlyByteBuf buffer) {
        int shopItemId = buffer.readInt();
        return new ServerBoundShopItemBuyPacket(shopItemId);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleServerPacketAsync(context, p -> {
            ShopService service = Services.getService(ShopService.class);
            Response r = service.purchaseItem((OnlinePlayer)p, this.shopItemId);
            p.showResponse(r);
        });
    }
}

