/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.base.response.Response;
import com.equestricraft.cdi.Services;
import com.equestricraft.mod.horse.jobwork.JobWorkService;
import com.equestricraft.mod.packet.PacketUtil;
import com.equestricraft.mod.player.OnlinePlayer;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ServerBoundShowWorkNeedingDoneMainOpenPacket {
    private final int horseId;
    private final int jobId;

    public ServerBoundShowWorkNeedingDoneMainOpenPacket(int horseId, int jobId) {
        this.horseId = horseId;
        this.jobId = jobId;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.horseId);
        buffer.writeInt(this.jobId);
    }

    public static ServerBoundShowWorkNeedingDoneMainOpenPacket decode(FriendlyByteBuf buffer) {
        int horseId = buffer.readInt();
        int jobId = buffer.readInt();
        return new ServerBoundShowWorkNeedingDoneMainOpenPacket(horseId, jobId);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleServerPacketAsync(context, p -> {
            JobWorkService service = Services.getService(JobWorkService.class);
            Response r = service.showJobWorkMenuForJob((OnlinePlayer)p, this.horseId, this.jobId);
            p.showResponse(r);
        });
    }
}

