/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.base.pagination.SortDirection;
import com.equestricraft.cdi.Services;
import com.equestricraft.core.horse.stud.HorseStudRegisterSortOrder;
import com.equestricraft.mod.horse.stud.HorseStudRegisterService;
import com.equestricraft.mod.packet.PacketUtil;
import com.equestricraft.mod.player.OnlinePlayer;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ServerBoundStudRegistrationListOpenRequestPacket {
    private final int registryId;
    private final HorseStudRegisterSortOrder sortOrder;
    private final SortDirection sortDirection;
    private final int pageNumber;

    public ServerBoundStudRegistrationListOpenRequestPacket(int registryId, HorseStudRegisterSortOrder sortOrder, SortDirection sortDirection, int pageNumber) {
        this.registryId = registryId;
        this.sortOrder = sortOrder;
        this.sortDirection = sortDirection;
        this.pageNumber = pageNumber;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.registryId);
        buffer.m_130068_((Enum)this.sortOrder);
        buffer.m_130068_((Enum)this.sortDirection);
        buffer.writeInt(this.pageNumber);
    }

    public static ServerBoundStudRegistrationListOpenRequestPacket decode(FriendlyByteBuf buffer) {
        int registryId = buffer.readInt();
        HorseStudRegisterSortOrder sortOrder = (HorseStudRegisterSortOrder)buffer.m_130066_(HorseStudRegisterSortOrder.class);
        SortDirection sortDirection = (SortDirection)buffer.m_130066_(SortDirection.class);
        int pageNumber = buffer.readInt();
        return new ServerBoundStudRegistrationListOpenRequestPacket(registryId, sortOrder, sortDirection, pageNumber);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleServerPacketAsync(context, p -> {
            HorseStudRegisterService service = Services.getService(HorseStudRegisterService.class);
            service.showRegister((OnlinePlayer)p, this.registryId, this.sortOrder, this.sortDirection, this.pageNumber);
        });
    }
}

