/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.base.response.Response;
import com.equestricraft.cdi.Services;
import com.equestricraft.mod.horse.stud.HorseStudRegisterService;
import com.equestricraft.mod.packet.PacketUtil;
import com.equestricraft.mod.player.OnlinePlayer;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ServerBoundStudRegistrationRequestPacket {
    private final int horseId;
    private final int groupId;

    public ServerBoundStudRegistrationRequestPacket(int horseId, int groupId) {
        this.horseId = horseId;
        this.groupId = groupId;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.horseId);
        buffer.writeInt(this.groupId);
    }

    public static ServerBoundStudRegistrationRequestPacket decode(FriendlyByteBuf buffer) {
        int horseId = buffer.readInt();
        int groupId = buffer.readInt();
        return new ServerBoundStudRegistrationRequestPacket(horseId, groupId);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleServerPacketAsync(context, p -> {
            HorseStudRegisterService service = Services.getService(HorseStudRegisterService.class);
            Response response = service.registerStud((OnlinePlayer)p, this.horseId, this.groupId);
            p.showResponse(response);
        });
    }
}

