/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.cdi.Services;
import com.equestricraft.mod.packet.PacketUtil;
import com.equestricraft.mod.player.OnlinePlayer;
import com.equestricraft.mod.tack.TackService;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ServerBoundTackInventoryPageOpenPacket {
    private final int horseId;
    private final int pageNumber;

    public ServerBoundTackInventoryPageOpenPacket(int horseId, int pageNumber) {
        this.horseId = horseId;
        this.pageNumber = pageNumber;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.horseId);
        buffer.writeInt(this.pageNumber);
    }

    public static ServerBoundTackInventoryPageOpenPacket decode(FriendlyByteBuf buffer) {
        int horseId = buffer.readInt();
        int pageNumber = buffer.readInt();
        return new ServerBoundTackInventoryPageOpenPacket(horseId, pageNumber);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleServerPacketAsync(context, p -> {
            TackService service = Services.getService(TackService.class);
            service.showTackItemsMenuToPlayer((OnlinePlayer)p, this.horseId, this.pageNumber);
        });
    }
}

