/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.base.response.Response;
import com.equestricraft.cdi.Services;
import com.equestricraft.core.horse.tack.HorseTackService;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.mod.packet.PacketUtil;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ServerBoundTackInventorySelectPacket {
    private final int horseId;
    private final UUID itemId;

    public ServerBoundTackInventorySelectPacket(int horseId, UUID itemId) {
        this.horseId = horseId;
        this.itemId = itemId;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.horseId);
        buffer.m_130077_(this.itemId);
    }

    public static ServerBoundTackInventorySelectPacket decode(FriendlyByteBuf buffer) {
        int horseId = buffer.readInt();
        UUID itemId = buffer.m_130259_();
        return new ServerBoundTackInventorySelectPacket(horseId, itemId);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleServerPacketAsync(context, p -> {
            HorseTackService service = Services.getService(HorseTackService.class);
            Response r = service.setTackOnHorse((ECPlayer)p, this.horseId, this.itemId);
            p.showResponse(r);
        });
    }
}

