/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.mod.packet.PacketUtil;
import com.equestricraft.mod.prompt.PromptResponsesHandler;
import com.equestricraft.mod.prompt.TransactionDetails;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ServerBoundTransactionEnterMenuConfirmPacket {
    private final UUID uuid;
    private final TransactionDetails transactionDetails;

    public ServerBoundTransactionEnterMenuConfirmPacket(UUID uuid, TransactionDetails transactionDetails) {
        this.uuid = uuid;
        this.transactionDetails = transactionDetails;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130077_(this.uuid);
        buffer.writeDouble(this.transactionDetails.amount());
        buffer.m_130070_(this.transactionDetails.reason());
    }

    public static ServerBoundTransactionEnterMenuConfirmPacket decode(FriendlyByteBuf buffer) {
        UUID uuid = buffer.m_130259_();
        double amount = buffer.readDouble();
        String reason = buffer.m_130277_();
        TransactionDetails details = new TransactionDetails(amount, reason);
        return new ServerBoundTransactionEnterMenuConfirmPacket(uuid, details);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleServerPacketAsync(context, p -> PromptResponsesHandler.getInstance().provideResponse((ECPlayer)p, this.uuid, this.transactionDetails));
    }
}

