/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.cdi.Services;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.university.UniversityService;
import com.equestricraft.mod.packet.PacketUtil;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ServerBoundUniversityExamResultPacket {
    private final int moduleId;
    private final int correct;
    private final int incorrect;

    public ServerBoundUniversityExamResultPacket(int moduleId, int correct, int incorrect) {
        this.moduleId = moduleId;
        this.correct = correct;
        this.incorrect = incorrect;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.moduleId);
        buffer.writeInt(this.correct);
        buffer.writeInt(this.incorrect);
    }

    public static ServerBoundUniversityExamResultPacket decode(FriendlyByteBuf buffer) {
        int moduleId = buffer.readInt();
        int correct = buffer.readInt();
        int incorrect = buffer.readInt();
        return new ServerBoundUniversityExamResultPacket(moduleId, correct, incorrect);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleServerPacketAsync(context, p -> {
            UniversityService service = Services.getService(UniversityService.class);
            service.processExamResult((ECPlayer)p, this.moduleId, this.correct, this.incorrect);
        });
    }
}

