/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.permission;

import com.equestricraft.common.version.BuildInformation;
import com.equestricraft.mod.player.ECPlayerJoinEvent;
import com.equestricraft.mod.player.OnlinePlayer;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.LuckPermsProvider;
import net.luckperms.api.model.group.Group;
import net.luckperms.api.model.group.GroupManager;
import net.luckperms.api.model.user.User;
import net.luckperms.api.model.user.UserManager;
import net.luckperms.api.node.Node;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.DEDICATED_SERVER})
public class PermissionListener {
    private static final String ADMIN_GROUP = "admin";
    private static final String DEFAULT_GROUP = "default";
    private static final String ALL_PERMISSIONS = "*";

    @SubscribeEvent
    public static void setupAdminGroup(ServerStartedEvent event) {
        LuckPerms luckPerms;
        GroupManager groupManager;
        if (BuildInformation.get().isDevBuild() && (groupManager = (luckPerms = LuckPermsProvider.get()).getGroupManager()).getGroup(ADMIN_GROUP) == null) {
            Group group = (Group)groupManager.createAndLoadGroup(ADMIN_GROUP).join();
            group.data().add((Node)Node.builder((String)ALL_PERMISSIONS).build());
            groupManager.saveGroup(group);
        }
    }

    @SubscribeEvent
    public static void giveAdminToOp(ECPlayerJoinEvent event) {
        if (BuildInformation.get().isDevBuild()) {
            LuckPerms luckPerms = LuckPermsProvider.get();
            OnlinePlayer player = event.getPlayer();
            UserManager userManager = luckPerms.getUserManager();
            ServerPlayer serverPlayer = player.require(OnlinePlayer.class).serverPlayer();
            User user = userManager.getUser(player.getAccountUuid());
            if (user.getPrimaryGroup().equals(DEFAULT_GROUP) && serverPlayer.m_20310_(4)) {
                user.data().add((Node)Node.builder((String)"group.admin").build());
                user.data().remove((Node)Node.builder((String)"group.default").build());
            }
            userManager.saveUser(user);
        }
    }

    private PermissionListener() {
    }
}

