/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.permission;

import com.equestricraft.core.permission.PermissionException;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.mod.permission.GroupInfo;
import com.equestricraft.mod.permission.PermissionService;
import com.equestricraft.mod.player.OnlinePlayer;
import java.util.UUID;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.LuckPermsProvider;
import net.luckperms.api.cacheddata.CachedPermissionData;
import net.luckperms.api.model.group.Group;
import net.luckperms.api.model.user.User;
import net.luckperms.api.node.Node;
import net.luckperms.api.node.NodeType;
import net.luckperms.api.node.types.InheritanceNode;
import net.luckperms.api.platform.PlayerAdapter;
import net.luckperms.api.util.Tristate;
import net.minecraft.server.level.ServerPlayer;

public class PermissionServiceImpl
implements PermissionService {
    private final LuckPerms luckPerms = LuckPermsProvider.get();

    @Override
    public boolean doesPlayerHavePermission(ServerPlayer serverPlayer, String permission) {
        PlayerAdapter adapter = this.luckPerms.getPlayerAdapter(ServerPlayer.class);
        CachedPermissionData data = adapter.getPermissionData((Object)serverPlayer);
        Tristate state = data.checkPermission(permission);
        return state.asBoolean();
    }

    @Override
    public GroupInfo getPlayersPrimaryGroup(ServerPlayer player) {
        Group group = this.getPrimaryGroup(player.m_142081_());
        return new GroupInfo(group.getDisplayName(), group.getCachedData().getMetaData().getPrefix());
    }

    @Override
    public boolean doesPlayerHavePermission(ECPlayer player, String permission) {
        ServerPlayer serverPlayer = player.require(OnlinePlayer.class).serverPlayer();
        return this.doesPlayerHavePermission(serverPlayer, permission);
    }

    @Override
    public GroupInfo getPlayersPrimaryGroup(ECPlayer player) {
        Group group = this.getPrimaryGroup(player.getAccountUuid());
        return new GroupInfo(group.getDisplayName(), group.getCachedData().getMetaData().getPrefix());
    }

    @Override
    public void givePermissionToPlayer(ECPlayer player, String permission) {
        User user = this.requireUser(player.getAccountUuid());
        user.data().add((Node)Node.builder((String)permission).build());
        this.luckPerms.getUserManager().saveUser(user);
    }

    @Override
    public void takePermissionFromPlayer(ECPlayer player, String permission) {
        User user = this.requireUser(player.getAccountUuid());
        user.data().remove((Node)Node.builder((String)permission).build());
        this.luckPerms.getUserManager().saveUser(user);
    }

    private Group getPrimaryGroup(UUID playerUuid) {
        User user = this.requireUser(playerUuid);
        return user.getNodes(NodeType.INHERITANCE).stream().map(InheritanceNode::getGroupName).findFirst().map(n -> this.luckPerms.getGroupManager().getGroup(n)).orElseThrow();
    }

    private User requireUser(UUID playerUuid) {
        User user = this.luckPerms.getUserManager().getUser(playerUuid);
        if (user == null) {
            throw new PermissionException("User not found");
        }
        return user;
    }
}

