/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.player;

import com.equestricraft.common.util.DateUtils;

public class DoublePressDetector {
    private int currentPressCount = 1;
    private Long lastPressTime = null;
    private static final Long DOUBLE_PRESS_DELAY = 500L;

    public int processPress() {
        try {
            if (this.lastPressTime != null && DateUtils.millisSince(this.lastPressTime) <= DOUBLE_PRESS_DELAY) {
                try {
                    int n = ++this.currentPressCount;
                    return n;
                }
                finally {
                    if (this.currentPressCount == 2) {
                        this.currentPressCount = 0;
                    }
                }
            }
            int n = this.currentPressCount = 1;
            return n;
        }
        finally {
            this.lastPressTime = System.currentTimeMillis();
        }
    }
}

