/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.player;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.PlayerListMessage;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.player.JoinBlockedException;
import com.equestricraft.core.player.LoginInfo;
import com.equestricraft.core.player.OnlinePlayerCache;
import com.equestricraft.core.player.PlayerJoinLeaveService;
import com.equestricraft.core.player.PlayerJoinResponse;
import com.equestricraft.core.player.nickname.Nickname;
import com.equestricraft.core.social.SocialSettings;
import com.equestricraft.mod.packet.ClientBoundPlayerDataUpdate;
import com.equestricraft.mod.packet.ClientBoundPlayerVisibilityPacket;
import com.equestricraft.mod.player.DoublePressDetector;
import com.equestricraft.mod.player.ECPlayerJoinEvent;
import com.equestricraft.mod.player.ECPlayerLeaveEvent;
import com.equestricraft.mod.player.ModPlayerJoinLeaveService;
import com.equestricraft.mod.player.OnlinePlayer;
import com.equestricraft.redis.RedisPublishChannel;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class ModPlayerJoinLeaveServiceImpl
implements ModPlayerJoinLeaveService {
    @Service
    private PlayerJoinLeaveService playerJoinLeaveService;
    private final OnlinePlayerCache onlinePlayerCache = OnlinePlayerCache.getInstance();
    private final RedisPublishChannel<PlayerListMessage> playerListMessageRedisPublishChannel = new RedisPublishChannel("online_player_list");

    @Override
    public void processJoin(ServerPlayer serverPlayer) {
        try {
            LoginInfo loginInfo = this.buildLoginInfo(serverPlayer);
            PlayerJoinResponse response = this.playerJoinLeaveService.processPlayerJoin(loginInfo);
            OnlinePlayer onlinePlayer = new OnlinePlayer(serverPlayer, response.player(), new DoublePressDetector());
            response.player().provideData(onlinePlayer);
            this.onlinePlayerCache.add(response.player());
            this.fireEcJoinEvent(onlinePlayer, response.wasNew());
            serverPlayer.refreshTabListName();
            this.sendPlayerListUpdate();
            this.sendPlayerDataUpdate(onlinePlayer);
            this.updatePlayerVisibility(onlinePlayer);
        }
        catch (JoinBlockedException ex) {
            serverPlayer.f_8906_.m_9942_((Component)new TextComponent(ex.getMessage()));
        }
        catch (Exception ex) {
            serverPlayer.f_8906_.m_9942_((Component)new TextComponent(I18n.getLabel("login.error-connecting", SocialSettings.getDiscordServer(), SocialSettings.getInstagram())));
        }
    }

    private void fireEcJoinEvent(OnlinePlayer player, boolean newPlayer) {
        ECPlayerJoinEvent event = new ECPlayerJoinEvent(player, newPlayer);
        MinecraftForge.EVENT_BUS.post((Event)event);
    }

    private LoginInfo buildLoginInfo(ServerPlayer serverPlayer) {
        return new LoginInfo(serverPlayer.m_142081_(), serverPlayer.m_7755_().m_6111_(), serverPlayer.m_9239_(), new Date());
    }

    @Override
    public void processPlayerLeave(ServerPlayer serverPlayer) {
        Optional<ECPlayer> onlinePlayer = this.onlinePlayerCache.getPlayer(serverPlayer.m_142081_());
        if (onlinePlayer.isPresent()) {
            onlinePlayer.get().getHorses().clearSelected();
            this.fireEcLeaveEvent(onlinePlayer.get());
            this.playerJoinLeaveService.processPlayerLeave(serverPlayer.m_142081_());
            this.onlinePlayerCache.removePlayer(onlinePlayer.get().getId());
            this.sendPlayerListUpdate();
        }
    }

    private void fireEcLeaveEvent(ECPlayer player) {
        ECPlayerLeaveEvent event = new ECPlayerLeaveEvent(player);
        MinecraftForge.EVENT_BUS.post((Event)event);
    }

    private void sendPlayerListUpdate() {
        List<PlayerListMessage.PlayerListMessageItem> players = this.onlinePlayerCache.getAllPlayers().stream().map(p -> new PlayerListMessage.PlayerListMessageItem(p.getId(), p.getAccountUuid(), p.getIgn(), p.getNickname().map(Nickname::getColorStripped).orElse(null))).toList();
        PlayerListMessage message = new PlayerListMessage(players);
        this.playerListMessageRedisPublishChannel.publish(message);
    }

    private void sendPlayerDataUpdate(OnlinePlayer player) {
        ClientBoundPlayerDataUpdate packet = new ClientBoundPlayerDataUpdate(player.getId());
        player.sendPacket(packet);
    }

    private void updatePlayerVisibility(OnlinePlayer player) {
        boolean shouldHide = player.getInductionMode().isIncomplete();
        ClientBoundPlayerVisibilityPacket packet = new ClientBoundPlayerVisibilityPacket(shouldHide);
        player.sendPacket(packet);
    }
}

