/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.player;

import com.equestricraft.base.task.TaskScheduler;
import com.equestricraft.cdi.Service;
import com.equestricraft.core.player.settings.PlayerSettingsDto;
import com.equestricraft.core.player.settings.PlayerSettingsSession;
import com.equestricraft.mod.packet.ClientBoundPlayerSettingsMenuScreenOpenPacket;
import com.equestricraft.mod.packet.ServerBoundPlayerSettingsUpdatePacket;
import com.equestricraft.mod.player.ModPlayerSettingsService;
import com.equestricraft.mod.player.OnlinePlayer;

public class ModPlayerSettingsServiceImpl
implements ModPlayerSettingsService {
    @Service
    private PlayerSettingsSession playerSettingsSession;

    @Override
    public void showSettingsMenuToPlayer(OnlinePlayer player) {
        PlayerSettingsDto settings = this.playerSettingsSession.getSettingsForPlayer(player);
        ClientBoundPlayerSettingsMenuScreenOpenPacket packet = new ClientBoundPlayerSettingsMenuScreenOpenPacket(settings);
        player.sendPacket(packet);
    }

    @Override
    public void updateSettingsForPlayer(OnlinePlayer player, ServerBoundPlayerSettingsUpdatePacket packet) {
        TaskScheduler.executeAsyncTask(() -> this.updateSettingsForPlayerImpl(player, packet));
    }

    private void updateSettingsForPlayerImpl(OnlinePlayer player, ServerBoundPlayerSettingsUpdatePacket packet) {
        if (packet.getHideChatDuringQuests() != null) {
            this.playerSettingsSession.updateHideChatDuringQuests(player, packet.getHideChatDuringQuests());
        }
        if (packet.getShowPlotMinimap() != null) {
            this.playerSettingsSession.updateShowPlotMinimap(player, packet.getShowPlotMinimap());
        }
    }
}

