/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.player;

import com.equestricraft.common.ECLevel;
import com.equestricraft.common.coordinate.BlockCoordinate;
import com.equestricraft.common.coordinate.Coordinate;
import com.equestricraft.common.coordinate.DirectionalCoordinate;
import com.equestricraft.core.player.CorePlayer;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.mod.player.DoublePressDetector;
import com.equestricraft.mod.player.display.PlayerDisplay;
import com.equestricraft.mod.util.BlockPosUtil;
import com.equestricraft.mod.util.ServerLevelUtil;
import java.util.Objects;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;

public final class OnlinePlayer
implements ECPlayer {
    private final ServerPlayer serverPlayer;
    private final ECPlayer player;
    private final DoublePressDetector doublePressDetector;
    private PlayerDisplay display = null;

    public OnlinePlayer(ServerPlayer serverPlayer, ECPlayer player, DoublePressDetector doublePressDetector) {
        if (!Objects.equals(serverPlayer.m_142081_(), player.getAccountUuid())) {
            throw new IllegalArgumentException("The ServerPlayer and ECPlayer must have the same UUID");
        }
        this.serverPlayer = serverPlayer;
        this.player = player;
        this.doublePressDetector = doublePressDetector;
    }

    public ServerPlayer serverPlayer() {
        return this.serverPlayer;
    }

    public ECPlayer player() {
        return this.player;
    }

    public DoublePressDetector doublePressDetector() {
        return this.doublePressDetector;
    }

    public void sendMessage(TextComponent component) {
        this.serverPlayer.m_6352_((Component)component, this.serverPlayer.m_142081_());
    }

    @Override
    public CorePlayer getCorePlayer() {
        return this.player.getCorePlayer();
    }

    public Coordinate getCoordinate() {
        return new Coordinate(this.serverPlayer.m_20185_(), this.serverPlayer.m_20186_(), this.serverPlayer.m_20189_(), this.getECLevel().getIdentifier());
    }

    public BlockCoordinate getBlockCoordinate() {
        return BlockPosUtil.toBlockCoordinate(this.serverPlayer.m_20097_(), (Level)this.serverPlayer.m_183503_());
    }

    public DirectionalCoordinate getDirectionalCoordinate() {
        return new DirectionalCoordinate(this.serverPlayer.m_20185_(), this.serverPlayer.m_20186_(), this.serverPlayer.m_20189_(), this.getECLevel().getIdentifier(), this.serverPlayer.m_146908_(), this.serverPlayer.m_146909_());
    }

    public ECLevel getECLevel() {
        return ServerLevelUtil.getEntitiesECLevel((Entity)this.serverPlayer);
    }

    public ServerLevel getServerLevel() {
        return this.serverPlayer.m_183503_();
    }

    public synchronized PlayerDisplay getDisplay() {
        if (this.display == null) {
            this.display = new PlayerDisplay(this);
        }
        return this.display;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ECPlayer)) {
            return false;
        }
        ECPlayer that = (ECPlayer)o;
        return Objects.equals(this.player, that);
    }

    public int hashCode() {
        return Objects.hash(this.player);
    }

    public String toString() {
        return this.player.toString();
    }
}

