/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.player;

import com.equestricraft.base.task.TaskScheduler;
import com.equestricraft.cdi.Service;
import com.equestricraft.mod.player.ModPlayerJoinLeaveService;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class PlayerJoinLeaveListener {
    @Service
    private static ModPlayerJoinLeaveService modPlayerJoinLeaveService;

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void playerJoined(PlayerEvent.PlayerLoggedInEvent event) {
        ServerPlayer serverPlayer = (ServerPlayer)event.getPlayer();
        TaskScheduler.executeAsyncTask(() -> modPlayerJoinLeaveService.processJoin(serverPlayer));
    }

    @SubscribeEvent
    public static void playerLeft(PlayerEvent.PlayerLoggedOutEvent event) {
        ServerPlayer serverPlayer = (ServerPlayer)event.getPlayer();
        TaskScheduler.executeAsyncTask(() -> modPlayerJoinLeaveService.processPlayerLeave(serverPlayer));
    }

    private PlayerJoinLeaveListener() {
    }
}

