/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.player;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.coordinate.DirectionalCoordinate;
import com.equestricraft.core.player.CorePlayer;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.player.PlayerRepository;
import com.equestricraft.core.player.location.PlayerLocationService;
import com.equestricraft.mod.player.OnlinePlayer;
import com.equestricraft.mod.util.TeleportUtil;
import java.util.Optional;
import net.minecraft.server.level.ServerPlayer;

public class PlayerLocationServiceImpl
implements PlayerLocationService {
    @Service
    private PlayerRepository playerRepository;

    @Override
    public Optional<DirectionalCoordinate> getPlayersLocation(int playerId) {
        CorePlayer player = (CorePlayer)this.playerRepository.findByKey(playerId);
        return this.getPlayersLocation(player);
    }

    @Override
    public Optional<DirectionalCoordinate> getPlayersLocation(ECPlayer player) {
        if (player.isOnline()) {
            OnlinePlayer onlinePlayer = player.require(OnlinePlayer.class);
            return Optional.of(onlinePlayer.getDirectionalCoordinate());
        }
        return Optional.empty();
    }

    @Override
    public void setPlayersLocation(int playerId, DirectionalCoordinate location) {
        CorePlayer player = (CorePlayer)this.playerRepository.findByKey(playerId);
        this.setPlayersLocation(player, location);
    }

    @Override
    public void setPlayersLocation(ECPlayer player, DirectionalCoordinate location) {
        ServerPlayer serverPlayer = player.require(OnlinePlayer.class).serverPlayer();
        TeleportUtil.teleportPlayer(serverPlayer, location);
    }
}

