/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.player;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.LocationRequestResponseMessage;
import com.equestricraft.common.PlayerLocationSetMessage;
import com.equestricraft.common.coordinate.DirectionalCoordinate;
import com.equestricraft.core.player.location.PlayerLocationService;
import com.equestricraft.core.system.SubSystem;
import com.equestricraft.redis.RedisChannelSubscription;
import com.equestricraft.redis.RedisRequestReceiver;
import java.util.Optional;

public class PlayerLocationSystem
implements SubSystem {
    @Service
    private PlayerLocationService playerLocationService;
    private final RedisRequestReceiver<Integer, LocationRequestResponseMessage> playerLocationRequestHandler = new RedisRequestReceiver("player_location_requester");
    private final RedisChannelSubscription<PlayerLocationSetMessage> playerLocationSetPublishChannel = new RedisChannelSubscription("player_location_set");

    @Override
    public void onEnable() {
        this.playerLocationSetPublishChannel.subscribe(this::handleSet);
        this.playerLocationRequestHandler.registerListener(this::handleRequest);
    }

    private LocationRequestResponseMessage handleRequest(int playerId) {
        Optional<DirectionalCoordinate> location = this.playerLocationService.getPlayersLocation(playerId);
        return new LocationRequestResponseMessage(location.orElse(null));
    }

    private void handleSet(PlayerLocationSetMessage message) {
        DirectionalCoordinate location = new DirectionalCoordinate(message.getX(), message.getY(), message.getZ(), message.getWorld(), message.getRotationY(), message.getRotationX());
        this.playerLocationService.setPlayersLocation(message.getPlayerId(), location);
    }
}

