/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.player;

import com.equestricraft.core.player.PlayerContextInfo;
import com.equestricraft.core.player.PlayerSimple;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;

public class PlayerSerializer {
    public static void serializePlayerSimple(PlayerSimple playerSimple, FriendlyByteBuf buffer) {
        buffer.writeInt(playerSimple.id());
        buffer.m_130070_(playerSimple.ign());
        if (playerSimple.nickname() != null) {
            buffer.writeBoolean(true);
            buffer.m_130070_(playerSimple.nickname());
        } else {
            buffer.writeBoolean(false);
        }
        buffer.m_130077_(playerSimple.accountUuid());
        buffer.writeBoolean(playerSimple.online());
    }

    public static PlayerSimple deserializePlayerSimple(FriendlyByteBuf buffer) {
        int id = buffer.readInt();
        String ign = buffer.m_130277_();
        String nickname = buffer.readBoolean() ? buffer.m_130277_() : null;
        UUID accountUuid = buffer.m_130259_();
        boolean online = buffer.readBoolean();
        return new PlayerSimple(id, ign, nickname, accountUuid, online);
    }

    public static void serializePlayerContextInfo(PlayerContextInfo playerContextInfo, FriendlyByteBuf buffer) {
        buffer.m_130070_(playerContextInfo.displayName());
        if (playerContextInfo.selectedHorseName() != null) {
            buffer.writeBoolean(true);
            buffer.m_130070_(playerContextInfo.selectedHorseName());
        } else {
            buffer.writeBoolean(false);
        }
        buffer.m_130070_(playerContextInfo.balance());
        buffer.m_130070_(playerContextInfo.rank());
        buffer.writeInt(playerContextInfo.xp());
        if (playerContextInfo.clubName() != null) {
            buffer.writeBoolean(true);
            buffer.m_130070_(playerContextInfo.clubName());
        } else {
            buffer.writeBoolean(false);
        }
    }

    public static PlayerContextInfo deserializePlayerContextInfo(FriendlyByteBuf buffer) {
        String displayName = buffer.m_130277_();
        String selectedHorseName = buffer.readBoolean() ? buffer.m_130277_() : null;
        String balance = buffer.m_130277_();
        String rank = buffer.m_130277_();
        int xp = buffer.readInt();
        String clubName = buffer.readBoolean() ? buffer.m_130277_() : null;
        return new PlayerContextInfo(displayName, selectedHorseName, balance, rank, xp, clubName);
    }

    private PlayerSerializer() {
    }
}

