/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.player.effect;

import com.equestricraft.common.Argb;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.player.effect.PlayerEffectSession;
import com.equestricraft.mod.packet.ClientBoundScreenFadePacket;
import com.equestricraft.mod.player.OnlinePlayer;
import com.equestricraft.mod.player.effect.MobEffectMap;
import java.time.Duration;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;

public class PlayerEffectSessionImpl
implements PlayerEffectSession {
    @Override
    public void playEffectToPlayer(ECPlayer player, String effectName, Duration duration, int amplifier) {
        ServerPlayer serverPlayer = player.require(OnlinePlayer.class).serverPlayer();
        MobEffect effect = MobEffectMap.getEffect(effectName);
        long millisDuration = duration.toMillis();
        int ticks = (int)(millisDuration / 50L);
        serverPlayer.m_7292_(new MobEffectInstance(effect, ticks, amplifier, false, true, false));
    }

    @Override
    public void stopEffectForPlayer(ECPlayer player, String effectName) {
        ServerPlayer serverPlayer = player.require(OnlinePlayer.class).serverPlayer();
        MobEffect effect = MobEffectMap.getEffect(effectName);
        serverPlayer.m_21195_(effect);
    }

    @Override
    public void screenFade(ECPlayer player, Duration fadeIn, Duration stay, Duration fadeOut, Argb color) {
        ClientBoundScreenFadePacket packet = new ClientBoundScreenFadePacket(fadeIn.toMillis(), stay.toMillis(), fadeOut.toMillis(), color);
        player.sendPacket(packet);
    }
}

