/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.player.friend;

import com.equestricraft.base.response.Response;
import com.equestricraft.base.response.ResponseFactory;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.player.CorePlayer;
import com.equestricraft.core.player.PlayerService;
import com.equestricraft.core.player.friend.PlayerFriendException;
import com.equestricraft.core.player.friend.PlayerFriendSession;
import com.equestricraft.mod.player.OnlinePlayer;
import com.equestricraft.mod.player.friend.PlayerFriendService;

public class PlayerFriendServiceImpl
implements PlayerFriendService {
    @Service
    private PlayerFriendSession playerFriendSession;
    @Service
    private PlayerService playerService;

    @Override
    public Response sendFriendRequest(OnlinePlayer sendingPlayer, String ign) {
        CorePlayer player = this.playerService.retrievePlayerByIgn(ign);
        try {
            this.playerFriendSession.sendFriendRequest(sendingPlayer, player);
            return ResponseFactory.success(I18n.getLabel("player.friend.request-sent", ign));
        }
        catch (PlayerFriendException ex) {
            return ResponseFactory.fail(ex);
        }
    }

    @Override
    public Response acceptFriendRequest(OnlinePlayer player, String ign) {
        CorePlayer playerToAccept = this.playerService.retrievePlayerByIgn(ign);
        this.playerFriendSession.acceptFriendRequest(player, playerToAccept);
        return ResponseFactory.success(I18n.getLabel("player.friend.request-accepted"));
    }

    @Override
    public Response denyFriendRequest(OnlinePlayer player, String ign) {
        CorePlayer playerToDeny = this.playerService.retrievePlayerByIgn(ign);
        this.playerFriendSession.denyFriendRequest(player, playerToDeny);
        return ResponseFactory.success(I18n.getLabel("player.friend.request-denied"));
    }
}

