/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.player.inventory;

import com.equestricraft.base.pagination.Pagination;
import com.equestricraft.base.pagination.SortDirection;
import com.equestricraft.core.item.ECItem;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.player.inventory.PlayerInventoryItemEntry;
import com.equestricraft.mod.player.inventory.ModPlayerInventoryPageService;
import com.equestricraft.mod.player.inventory.PlayerInventoryListItem;
import com.equestricraft.mod.player.inventory.PlayerInventoryPage;
import java.util.Comparator;
import java.util.List;

public class ModPlayerInventoryPageServiceImpl
extends Pagination<PlayerInventoryListItem, PlayerInventoryPage, Object, Object>
implements ModPlayerInventoryPageService {
    private static final int MAXIMUM_PER_PAGE = 10;

    @Override
    public PlayerInventoryPage retrievePage(ECPlayer player, int pageNumber) {
        List<PlayerInventoryItemEntry<?>> inventoryItems = player.getInventory().getItems();
        List<PlayerInventoryListItem> items = inventoryItems.stream().map(this::buildListItem).toList();
        return (PlayerInventoryPage)this.paginate(items, pageNumber, SortDirection.ASCENDING, null, null);
    }

    private PlayerInventoryListItem buildListItem(PlayerInventoryItemEntry<?> playerInventoryItemEntry) {
        return new PlayerInventoryListItem(((ECItem)playerInventoryItemEntry.getItem()).getTypeDiscriminator(), ((ECItem)playerInventoryItemEntry.getItem()).getId(), ((ECItem)playerInventoryItemEntry.getItem()).getName(), ((ECItem)playerInventoryItemEntry.getItem()).getDescription(), playerInventoryItemEntry.getQuantity());
    }

    @Override
    protected int getMaximumPerPage() {
        return 10;
    }

    @Override
    protected boolean filter(PlayerInventoryListItem item, Object filterObject) {
        return true;
    }

    @Override
    protected Comparator<PlayerInventoryListItem> compare(Object sortOrderObject) {
        return Comparator.comparing(PlayerInventoryListItem::itemName);
    }

    @Override
    protected PlayerInventoryPage buildPage(List<PlayerInventoryListItem> items, int pageNumber, int totalPages, SortDirection sortDirection, Object sortObject, Object filterObject) {
        return new PlayerInventoryPage(items, pageNumber, totalPages, sortDirection, sortObject, filterObject);
    }
}

