/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.player.notification;

import com.equestricraft.base.pagination.SortDirection;
import com.equestricraft.base.response.Response;
import com.equestricraft.base.response.ResponseFactory;
import com.equestricraft.base.task.TaskScheduler;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.player.confirmation.ConfirmResponse;
import com.equestricraft.core.player.notification.PlayerNotificationPage;
import com.equestricraft.core.player.notification.PlayerNotificationPageService;
import com.equestricraft.core.player.notification.PlayerNotificationSession;
import com.equestricraft.mod.packet.ClientBoundPlayerNotificationChangePacket;
import com.equestricraft.mod.packet.ClientBoundPlayerNotificationMenuOpenPacket;
import com.equestricraft.mod.player.notification.ModPlayerNotificationService;
import java.time.Duration;
import java.util.Date;

public class ModPlayerNotificationServiceImpl
implements ModPlayerNotificationService {
    @Service
    private PlayerNotificationPageService playerNotificationPageService;
    @Service
    private PlayerNotificationSession playerNotificationSession;

    @Override
    public void showNotificationsForPlayer(ECPlayer player) {
        this.showNotificationsForPlayer(player, 1, SortDirection.ASCENDING, "");
    }

    @Override
    public void showNotificationsForPlayer(ECPlayer player, int pageNumber, SortDirection sortDirection, String textSearch) {
        PlayerNotificationPage page = this.playerNotificationPageService.retrievePlayerNotificationPage(player, pageNumber, sortDirection, textSearch);
        ClientBoundPlayerNotificationMenuOpenPacket packet = new ClientBoundPlayerNotificationMenuOpenPacket(page);
        player.sendPacket(packet);
    }

    @Override
    public void notifyPlayerOfNewNotificationsSinceLastOn(ECPlayer player) {
        this.notifyPlayerOfNewNotificationsSinceTime(player, player.getCorePlayer().getLastSeen());
    }

    @Override
    public void notifyPlayerOfNewNotificationsSinceTime(ECPlayer player, Date time) {
        TaskScheduler.executeAsyncTask(() -> this.notifyPlayer(player, time), Duration.ofSeconds(2L));
    }

    private void notifyPlayer(ECPlayer player, Date time) {
        boolean hasNotifications = this.playerNotificationSession.hasNotificationsSince(player, time);
        if (hasNotifications) {
            player.getAlert().alert(I18n.getLabel("player-notifications.new-notifications-alert.prompt.title"), I18n.getLabel("player-notifications.new-notifications-alert.prompt.text", Character.valueOf('N')));
        }
    }

    @Override
    public Response clearAllPlayersNotifications(ECPlayer player) {
        ConfirmResponse response = player.getConfirmation().confirm(I18n.getLabel("player-notifications.clear-all.confirm.prompt.title"), I18n.getLabel("player-notifications.clear-all.confirm.prompt.message"));
        if (response.isYes()) {
            this.playerNotificationSession.clearAllNotificationsForPlayer(player);
            return ResponseFactory.success(I18n.getLabel("player-notifications.clear-all.success.prompt.title"), I18n.getLabel("player-notifications.clear-all.success.prompt.message"));
        }
        return ResponseFactory.fail();
    }

    @Override
    public void sendClientNotificationUpdate(ECPlayer player) {
        int count = this.playerNotificationSession.getPlayersNotificationCount(player);
        ClientBoundPlayerNotificationChangePacket packet = new ClientBoundPlayerNotificationChangePacket(count);
        player.sendPacket(packet);
    }
}

