/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.player.notification;

import com.equestricraft.base.eventbus.ECEventBusListener;
import com.equestricraft.cdi.Service;
import com.equestricraft.core.player.notification.PlayerNotificationUpdateEvent;
import com.equestricraft.mod.packet.ClientBoundPlayerNotificationChangePacket;
import com.equestricraft.mod.player.ECPlayerJoinEvent;
import com.equestricraft.mod.player.notification.ModPlayerNotificationService;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.DEDICATED_SERVER})
public class NotificationsListener {
    @Service
    private static ModPlayerNotificationService modPlayerNotificationService;

    @SubscribeEvent
    public static void checkNotificationsOnJoin(ECPlayerJoinEvent event) {
        modPlayerNotificationService.notifyPlayerOfNewNotificationsSinceLastOn(event.getPlayer());
        modPlayerNotificationService.sendClientNotificationUpdate(event.getPlayer());
    }

    @ECEventBusListener
    public static void onNotificationChange(PlayerNotificationUpdateEvent event) {
        ClientBoundPlayerNotificationChangePacket packet = new ClientBoundPlayerNotificationChangePacket(event.getNotificationCount());
        event.getPlayer().sendPacket(packet);
    }

    private NotificationsListener() {
    }
}

