/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.player.search;

import com.equestricraft.base.pagination.Pagination;
import com.equestricraft.base.pagination.SortDirection;
import com.equestricraft.cdi.Service;
import com.equestricraft.core.player.CorePlayer;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.player.PlayerRepository;
import com.equestricraft.core.player.PlayerTransformer;
import com.equestricraft.core.player.friend.PlayerFriendSession;
import com.equestricraft.mod.player.search.PlayerSearchItem;
import com.equestricraft.mod.player.search.PlayerSearchPage;
import com.equestricraft.mod.player.search.PlayerSearchRequest;
import com.equestricraft.mod.player.search.PlayerSearchSession;
import java.util.Comparator;
import java.util.List;

public class PlayerSearchSessionImpl
extends Pagination<PlayerSearchItem, PlayerSearchPage, Object, PlayerSearchRequest>
implements PlayerSearchSession {
    @Service
    private PlayerRepository playerRepository;
    @Service
    private PlayerFriendSession playerFriendSession;
    @Service
    private PlayerTransformer playerTransformer;
    private static final int MAXIMUM_PER_PAGE = 8;

    @Override
    public PlayerSearchPage searchPlayers(ECPlayer searchingPlayer, PlayerSearchRequest searchRequest, int pageNumber) {
        List<CorePlayer> friendedPlayers = this.playerFriendSession.retrievePlayersFriends(searchingPlayer);
        List<PlayerSearchItem> items = this.playerRepository.streamAll().map(p -> this.toItem((ECPlayer)p, friendedPlayers)).toList();
        return (PlayerSearchPage)this.paginate(items, pageNumber, SortDirection.ASCENDING, null, searchRequest);
    }

    private PlayerSearchItem toItem(ECPlayer player, List<CorePlayer> playersFriendedPlayers) {
        return new PlayerSearchItem(this.playerTransformer.toSimple(player.getCorePlayer()), playersFriendedPlayers.stream().anyMatch(p -> p.getId() == player.getId()));
    }

    @Override
    protected int getMaximumPerPage() {
        return 8;
    }

    @Override
    protected boolean filter(PlayerSearchItem item, PlayerSearchRequest filterObject) {
        if (filterObject.mustBeOnline() && !item.player().online()) {
            return false;
        }
        if (filterObject.mustBeOnline() && !item.starredBySearchingPlayer()) {
            return false;
        }
        String text = filterObject.searchText().toLowerCase().trim();
        boolean ignMatches = item.player().ign().toLowerCase().contains(text);
        if (ignMatches) {
            return true;
        }
        return item.player().hasNickname() && item.player().nickname().toLowerCase().contains(text);
    }

    @Override
    protected Comparator<PlayerSearchItem> compare(Object sortOrderObject) {
        return Comparator.comparing(PlayerSearchItem::starredBySearchingPlayer).thenComparing(i -> i.player().ign());
    }

    @Override
    protected PlayerSearchPage buildPage(List<PlayerSearchItem> items, int pageNumber, int totalPages, SortDirection sortDirection, Object sortObject, PlayerSearchRequest filterObject) {
        return new PlayerSearchPage(items, pageNumber, totalPages, sortDirection, sortObject, filterObject);
    }
}

