/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.plot;

import com.equestricraft.base.pagination.Pagination;
import com.equestricraft.base.pagination.SortDirection;
import com.equestricraft.cdi.Service;
import com.equestricraft.core.plot.access.PlotAccessInfo;
import com.equestricraft.core.plot.access.PlotPlayerAccessSession;
import com.equestricraft.mod.plot.PlotAccessPage;
import com.equestricraft.mod.plot.PlotAccessPageService;
import java.util.Comparator;
import java.util.List;

public class PlotAccessPageServiceImpl
extends Pagination<PlotAccessInfo, PlotAccessPage, Object, Object>
implements PlotAccessPageService {
    @Service
    private PlotPlayerAccessSession plotPlayerAccessSession;
    private static final int MAXIMUM_PER_PAGE = 8;

    @Override
    public PlotAccessPage retrieveAccessPage(int plotId, int pageNumber) {
        List<PlotAccessInfo> items = this.plotPlayerAccessSession.retrieveAllAccessesForPlot(plotId);
        return (PlotAccessPage)this.paginate(items, pageNumber, SortDirection.ASCENDING, null, null);
    }

    @Override
    protected int getMaximumPerPage() {
        return 8;
    }

    @Override
    protected boolean filter(PlotAccessInfo item, Object filterObject) {
        return true;
    }

    @Override
    protected Comparator<PlotAccessInfo> compare(Object sortOrderObject) {
        return Comparator.comparing(i -> i.player().ign());
    }

    @Override
    protected PlotAccessPage buildPage(List<PlotAccessInfo> items, int pageNumber, int totalPages, SortDirection sortDirection, Object sortObject, Object filterObject) {
        return new PlotAccessPage(items, pageNumber, totalPages, sortDirection, sortObject, filterObject);
    }
}

