/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.plot;

import com.equestricraft.common.ECLevel;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.player.OnlinePlayerCache;
import com.equestricraft.core.plot.Plot;
import com.equestricraft.mod.chat.channel.ChatChannel;
import com.equestricraft.mod.player.OnlinePlayer;
import java.util.List;

public class PlotChatChannel
implements ChatChannel {
    private final Plot plot;
    private static final OnlinePlayerCache onlinePlayerCache = OnlinePlayerCache.getInstance();
    private static final List<ECLevel> plotLevels = List.of(ECLevel.PLOT_GRID, ECLevel.PLOT_NATURAL);

    public PlotChatChannel(Plot plot) {
        this.plot = plot;
    }

    public Plot getPlot() {
        return this.plot;
    }

    @Override
    public String getName() {
        return I18n.getLabel("plot.chat.prefix", this.plot.getName());
    }

    @Override
    public boolean isPlayerIn(ECPlayer player) {
        if (!player.getPlots().isPlotChat()) {
            return false;
        }
        OnlinePlayer onlinePlayer = player.require(OnlinePlayer.class);
        if (!plotLevels.contains((Object)onlinePlayer.getECLevel())) {
            return false;
        }
        return onlinePlayer.getPlots().getCurrentPlot().filter(this.plot::equals).isPresent();
    }

    @Override
    public List<ECPlayer> getPlayers() {
        return onlinePlayerCache.getAllPlayers().stream().filter(p -> p.getPlots().isPlotChat()).filter(p -> p.getPlots().getCurrentPlot().filter(this.plot::equals).isPresent()).toList();
    }
}

