/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.plot;

import com.equestricraft.base.response.Response;
import com.equestricraft.cdi.Service;
import com.equestricraft.mod.command.Arg;
import com.equestricraft.mod.command.Async;
import com.equestricraft.mod.command.Command;
import com.equestricraft.mod.context.ModPlayerContext;
import com.equestricraft.mod.player.OnlinePlayer;
import com.equestricraft.mod.plot.PlotService;

@Command(value="plot")
public class PlotCommand {
    @Service
    private PlotService plotService;

    @Async
    @Command
    public Response onPlot() {
        OnlinePlayer player = ModPlayerContext.getOnlinePlayer();
        return this.plotService.showCurrentPlotMenu(player);
    }

    @Async
    @Command(value="purchase")
    public Response onPurchase() {
        OnlinePlayer player = ModPlayerContext.getOnlinePlayer();
        return this.plotService.showPurchaseMenu(player);
    }

    @Async
    @Command(value="set-spawn")
    public Response setSpawn() {
        OnlinePlayer player = ModPlayerContext.getOnlinePlayer();
        return this.plotService.setSpawn(player);
    }

    @Async
    @Command(value="list")
    public void list() {
        OnlinePlayer player = ModPlayerContext.getOnlinePlayer();
        this.plotService.showPlayersPlotMenu(player);
    }

    @Async
    @Command(value="pending-approvals")
    public void pendingApprovals() {
        OnlinePlayer player = ModPlayerContext.getOnlinePlayer();
        this.plotService.showPendingApprovalsMenuToPlayer(player);
    }

    @Async
    @Command(value="step-down-as-owner")
    public Response stepDownAsOwner() {
        OnlinePlayer player = ModPlayerContext.getOnlinePlayer();
        return this.plotService.stepDownAsOwner(player);
    }

    @Async
    @Command(value="auto")
    public Response auto() {
        OnlinePlayer player = ModPlayerContext.getOnlinePlayer();
        return this.plotService.autoPurchasePlot(player);
    }

    @Async
    @Command(value="auto")
    public Response auto(@Arg(restOfString=true) String name) {
        OnlinePlayer player = ModPlayerContext.getOnlinePlayer();
        return this.plotService.autoPurchasePlot(player, name);
    }

    @Async
    @Command(value="delete")
    public Response delete() {
        OnlinePlayer player = ModPlayerContext.getOnlinePlayer();
        return this.plotService.deletePlot(player);
    }

    @Async
    @Command(value="map")
    public Response map() {
        OnlinePlayer player = ModPlayerContext.getOnlinePlayer();
        return this.plotService.showMap(player);
    }

    @Async
    @Command(value="merge")
    public Response merge() {
        OnlinePlayer player = ModPlayerContext.getOnlinePlayer();
        return this.plotService.showMergeMenu(player);
    }

    @Async
    @Command(value="purge")
    public Response purge() {
        OnlinePlayer player = ModPlayerContext.getOnlinePlayer();
        return this.plotService.purgeWorld(player);
    }

    @Async
    @Command(value="world")
    public Response plotWorld() {
        OnlinePlayer player = ModPlayerContext.getOnlinePlayer();
        return this.plotService.sendPlayerToPlotWorld(player);
    }

    @Async
    @Command(value="chat")
    public Response onChat() {
        OnlinePlayer player = ModPlayerContext.getOnlinePlayer();
        return this.plotService.togglePlotChat(player);
    }
}

