/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.plot;

import com.equestricraft.base.task.TaskScheduler;
import com.equestricraft.common.DelegateProcessor;
import com.equestricraft.common.coordinate.Area2D;
import com.equestricraft.common.coordinate.Point2D;
import com.equestricraft.common.util.ListUtils;
import com.equestricraft.core.plot.GridPlot;
import com.equestricraft.core.plot.PlotCoordinate;
import com.equestricraft.core.plot.PlotCoordinateUtility;
import com.equestricraft.mod.plot.PlotGridResetSession;
import com.equestricraft.mod.util.ServerLevelUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class PlotGridResetSessionImpl
implements PlotGridResetSession {
    private static final int Y_BOTTOM = -64;
    private static final int Y_TOP = 512;
    private static final int Y_STONE_TOP = 58;
    private static final int Y_DIRT_TOP = 63;
    private static final int Y_GRASS_TOP = 64;
    private final DelegateProcessor plotClearProcessor = DelegateProcessor.getNewDelegateProcessor();

    @Override
    public void resetPlot(GridPlot plot) {
        ServerLevel plotWorld = ServerLevelUtil.getPlotGrid();
        for (PlotCoordinate plotArea : plot.getAreas()) {
            Area2D area = PlotCoordinateUtility.getAreaOfPlotCoordinate(plotArea);
            int y = -64;
            while (y <= 512) {
                int fy = y++;
                this.plotClearProcessor.delegate(() -> this.resetYLevel(plotWorld, area, fy));
            }
        }
    }

    private void resetYLevel(ServerLevel plotWorld, Area2D area, int y) {
        ArrayList<Update> updates = new ArrayList<Update>(area.size());
        Block targetBlock = this.getBlockForYLevel(y);
        for (int x = area.x1(); x <= area.x2(); ++x) {
            for (int z = area.z1(); z <= area.z2(); ++z) {
                BlockPos position = new BlockPos(x, y, z);
                Block blockToUse = y >= 65 && y <= 68 && PlotCoordinateUtility.isPlotPath(new Point2D(x, z)) ? Blocks.f_50069_ : targetBlock;
                BlockState blockAtPosition = plotWorld.m_8055_(position);
                if (blockAtPosition.m_60713_(blockToUse)) continue;
                updates.add(new Update(position, blockToUse.m_49966_()));
            }
        }
        List batches = ListUtils.batch(updates, 1000);
        for (List batch : batches) {
            TaskScheduler.executeSyncTask(() -> batch.forEach(u -> plotWorld.m_7731_(u.pos(), u.blockState(), 3)));
        }
    }

    private Block getBlockForYLevel(int yLevel) {
        if (yLevel <= 58) {
            return Blocks.f_50069_;
        }
        if (yLevel <= 63) {
            return Blocks.f_50493_;
        }
        if (yLevel == 64) {
            return Blocks.f_50440_;
        }
        return Blocks.f_50016_;
    }

    private record Update(BlockPos pos, BlockState blockState) {
    }
}

